package com.xebialabs.deployit.plugin.test.v3;

import java.util.ArrayList;
import java.util.List;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.Range;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.cloud.ci.EnvironmentTemplate;
import com.xebialabs.deployit.plugin.test.v3.step.CreateVirtualEnvironmentStep;
import com.xebialabs.deployit.plugin.test.v3.step.CreateVirtualHostStep;

import static com.google.common.collect.DiscreteDomain.integers;
import static com.google.common.collect.FluentIterable.from;
import static com.google.common.collect.Lists.newArrayList;

@SuppressWarnings("serial")
public class DummyEnvironmentTemplate extends EnvironmentTemplate {

    @Property(required = true, size = Property.Size.SMALL, label = "Amount of hosts")
    private int amount;

    @ControlTask(parameterType = "test-v3.TemplateParameters")
    public List<Step> instantiate(final TemplateParameters params) {

        ArrayList<Step> result = newArrayList();

        Range<Integer> closed = Range.closed(1, amount);
        result.addAll(newArrayList(from(ContiguousSet.create(closed, integers())).transform((final Integer input) ->
            new CreateVirtualHostStep(params.getEnvironmentId(), params.getHostsLocation(), "cloudHost" + input)
        )));

        result.add(new CreateVirtualEnvironmentStep(params.getEnvironmentId(), this));

        return result;
    }

    public int getAmount() {
        return amount;
    }

    public void setAmount(final int amount) {
        this.amount = amount;
    }
}
