package com.xebialabs.deployit.plugin.test.v3;

import java.util.List;
import java.util.Set;

import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseEmbeddedDeployed;

import static com.google.common.collect.Lists.newArrayList;
import static com.google.common.collect.Sets.newHashSet;

@SuppressWarnings("serial")
public class DeployedPortlet extends BaseEmbeddedDeployed<Portlet, PortalWarModule> {

    @Property(required = true)
    private String portletName;

    @Property(required = false)
    private int startWeight;

    @Property(asContainment = true, required = false)
    private Set<DeployedPortletSettings> settings = newHashSet();

    @Property(asContainment = true, required = false)
    private List<DeployedPortletAttributes> attributes = newArrayList();

    public String getPortletName() {
        return portletName;
    }

    public Set<DeployedPortletSettings> getSettings() {
        return settings;
    }

    public List<DeployedPortletAttributes> getAttributes() {
        return attributes;
    }
}
