package com.xebialabs.deployit.plugin.test.yak.step;

import com.xebialabs.deployit.plugin.api.rules.StepMetadata;
import com.xebialabs.deployit.plugin.api.rules.StepParameter;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;

@StepMetadata(name="rule-deployed-xml-step")
public class RuleXmlDeployedStep implements Step {

    @StepParameter(description = "this is a xml deployed param")
    private String testParam;

    @StepParameter(description = "order of execution")
    private Integer order;

    @StepParameter(description = "Description of the step")
    private String description;

    public String getTestParam() {
        return testParam;
    }

    @Override
    public int getOrder() {
        return order;
    }

    @Override
    public String getDescription() {
        return "My deployed XML rule test step";
    }

    @Override
    public StepExitCode execute(final ExecutionContext ctx) throws Exception {
        ctx.logOutput("log output " + testParam);
        return StepExitCode.SUCCESS;
    }
}
