package com.xebialabs.deployit.plugin.test.yak.ci;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.test.yak.step.BreedingStep;
import com.xebialabs.deployit.plugin.test.yak.step.StampedeStep;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public interface HerdBase {

    default List<Step> breed(final HerdParameters params) {
        Stream<Integer> closedStream = IntStream.rangeClosed(1, params.getYaksToBreed()).boxed();
        return closedStream.map(
                (final Integer input) -> new BreedingStep(input, params.getYakBaseName())
        ).collect(Collectors.toList());
    }

    default List<Step> stampedeApocalypse() {
        return Collections.singletonList(new StampedeStep());
    }
}
