package com.xebialabs.deployit.plugin.test.yak.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.rules.StepMetadata;
import com.xebialabs.deployit.plugin.api.rules.StepParameter;

@StepMetadata(name="rule-disabledeployed-step")
public class RuleDisableDeployedStep implements Step {

    @StepParameter(description = "this is a deployed param")
    private String testParam;

    public String getTestParam() {
        return testParam;
    }

    @Override
    public int getOrder() {
        return 40;
    }

    @Override
    public String getDescription() {
        return "My disable deployed rule test step";
    }

    @Override
    public StepExitCode execute(final ExecutionContext ctx) throws Exception {
        ctx.logOutput("log output " + testParam);
        return StepExitCode.SUCCESS;
    }
}

