package com.xebialabs.deployit.plugin.test.v3;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.validation.Regex;
import com.xebialabs.deployit.plugin.cloud.ci.CloudEnvironmentParameters;

@SuppressWarnings("serial")
@Metadata(description = "Parameters for a Template")
public class TemplateParameters extends CloudEnvironmentParameters {

    @Property(required = true, defaultValue = "Environments/virtualEnvironment", label = "Environment id", description = "Id of the environment you want to create")
    @Regex(pattern = "Environments/.*", message = "Environment id should start with \"Environments/\".")
    private String environmentId;

    @Property(required = true, defaultValue = "Infrastructure/", label = "Hosts location", description = "Repository location where all created hosts will appear")
    @Regex(pattern = "Infrastructure/.*", message = "Host location should start with \"Infrastructure/\".")
    private String hostsLocation;

    @Override
    public String getEnvironmentId() {
        return environmentId;
    }

    @Override
    public void setEnvironmentId(final String environmentId) {
        this.environmentId = environmentId;
    }

    public String getHostsLocation() {
        return hostsLocation;
    }

    public void setHostsLocation(final String hostsLocation) {
        this.hostsLocation = hostsLocation;
    }
}
