package com.xebialabs.deployit.plugin.test.v3;

import java.util.Set;

import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;
import com.xebialabs.deployit.plugin.test.v3.step.PortletStep;
import com.xebialabs.deployit.plugin.test.v3.step.PortletWarStep;
import static com.google.common.collect.Sets.newHashSet;

@SuppressWarnings("serial")
public class PortalWarModule extends BaseDeployed<PortalWar, DummyJeeServer> {

    @Property(asContainment = true, required = false)
    private Set<DeployedPortlet> portlets = newHashSet();

    public Set<DeployedPortlet> getPortlets() {
        return portlets;
    }

    @Create
    @Destroy
    public void create(DeploymentPlanningContext result, Delta delta) {

        result.addStepWithCheckpoint(new PortletWarStep(this), delta);

        for(DeployedPortlet portlet : portlets){
            result.addStep(new PortletStep(portlet));
        }

    }

}
