package com.xebialabs.deployit.plugin.test.yak.step;

import com.xebialabs.deployit.plugin.api.deployment.planning.DefaultOrders;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.test.yak.ci.Meadow;

public class GrazingStep implements Step {
    private String name;
    private Meadow meadow;

    public GrazingStep(String name, Meadow meadow) {
        this.name = name;
        this.meadow = meadow;
    }

    @Override
    public int getOrder() {
        return DefaultOrders.DEPLOY_ARTIFACTS;
    }

    @Override
    public String getDescription() {
        return "Grazing " + name + " on meadow " + meadow.getId();
    }

    @Override
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        return StepExitCode.SUCCESS;
    }
}
