package com.xebialabs.deployit.plugin.test.yak.step;

import com.xebialabs.deployit.plugin.api.deployment.planning.DefaultOrders;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.test.yak.ci.Meadow;

public class StableStep implements Step {
    private String name;
    private Meadow meadow;

    public StableStep(String name, Meadow meadow) {
        this.name = name;
        this.meadow = meadow;
    }


    @Override
    public int getOrder() {
        return DefaultOrders.UNDEPLOY_ARTIFACTS;
    }

    @Override
    public String getDescription() {
        return "Returning " + name + " from meadow " + meadow.getId() + " to the stable.";
    }

    @Override
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        return StepExitCode.SUCCESS;
    }
}
