package com.xebialabs.deployit.plugin.test.v3.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.test.v3.DummyEnvironmentTemplate;
import com.xebialabs.deployit.plugin.test.v3.VirtualEnvironment;

import java.util.Set;

@SuppressWarnings("serial")
public class CreateVirtualEnvironmentStep implements Step {

    private final String environmentId;
    private final DummyEnvironmentTemplate template;

    public CreateVirtualEnvironmentStep(final String environmentId, final DummyEnvironmentTemplate dummyEnvironmentTemplate){
        this.environmentId = environmentId;
        this.template = dummyEnvironmentTemplate;
    }

    @Override
    public int getOrder() {
        return 40;
    }

    @Override
    public String getDescription() {
        return "Creating environment: " + environmentId;
    }

    @Override
    public StepExitCode execute(final ExecutionContext ctx) throws Exception {
        try {
            ctx.logOutput("creating environment " + environmentId);
            Repository repository = ctx.getRepository();
            VirtualEnvironment environment = Type.valueOf(VirtualEnvironment.class).getDescriptor().newInstance(environmentId);
            environment.setTemplate(template);
            environment.setLinkedCis((Set<ConfigurationItem>) ctx.getAttribute("hosts"));
            repository.create(environment);
            return StepExitCode.SUCCESS;
        } catch(Exception e){
            ctx.logError("Exception while trying to create environment", e);
            return StepExitCode.FAIL;
        }
    }
}
