package com.xebialabs.deployit.plugin.test.yak.step;

import com.xebialabs.deployit.plugin.api.flow.*;
import com.xebialabs.deployit.plugin.test.yak.ci.DeployedStageableYak;

public class YakMilkingStep implements Step, StageableStep {
    private DeployedStageableYak deployedStageableYak;

    public YakMilkingStep(DeployedStageableYak deployedStageableYak) {
        this.deployedStageableYak = deployedStageableYak;
    }

    @Override
    public void requestStaging(StagingContext ctx) {
        ctx.stageArtifact(deployedStageableYak, deployedStageableYak.getContainer());
    }

    @Override
    public int getOrder() {
        return 50;
    }

    @Override
    public String getDescription() {
        return "Milk the yak";
    }

    @Override
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        return StepExitCode.SUCCESS;
    }
}
