package com.xebialabs.deployit.plugin.test.yak.step;

import com.xebialabs.deployit.plugin.api.flow.*;

@SuppressWarnings("serial")
public class YakPreviewStep implements Step, PreviewStep {

    private boolean create;

    public YakPreviewStep(boolean create) {
        this.create = create;
    }

    @Override
    public Preview getPreview() {
        if (create) {
            return Preview.withContents("10 GOTO 20\r\n" +
                    "20 PRINTLN \"Hello World\"\r\n" +
                    "30 PRINTLN \"I'm a stupid Basic Script\"");
        } else {
            return Preview.withContents("10 PRINTLN \"Bye bye cruel world...\"");
        }
    }

    @Override
    public int getOrder() {
        return 40;
    }

    @Override
    public String getDescription() {
        return "I execute some script...";
    }

    @Override
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        return StepExitCode.SUCCESS;
    }
}
