package com.xebialabs.deployit.plugin.test.yak.ci;

import java.io.File;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployedArtifact;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;

@SuppressWarnings("serial")
@Metadata(virtual = false)
public class DeployedYakPlaceholders extends BaseDeployedArtifact<PlaceholdersYakFile, YakServer> {

    @Property
    private String tempFile;

    @Create
    public void createFile(DeploymentPlanningContext ctx, Delta d) {
        logger.info("Running @Create for {}", getId());
        ctx.addStepWithCheckpoint(new Step() {
            @Override
            public int getOrder() {
                return 1;
            }

            @Override
            public String getDescription() {
                return "";
            }

            @Override
            public StepExitCode execute(ExecutionContext ctx) throws Exception {
                OverthereFile file = getFile();
                logger.info("Copying to file {}", tempFile);
                file.copyTo(LocalFile.valueOf(new File(tempFile)));
                return StepExitCode.SUCCESS;
            }
        }, d);
    }

    @Destroy
    public void undeployFile(DeploymentPlanningContext ctx, Delta d) {
        logger.info("Running destroy for {}", getId());
        ctx.addStepWithCheckpoint(new Step() {

            @Override
            public int getOrder() {
                return 1;
            }

            @Override
            public String getDescription() {
                return "";
            }

            @Override
            public StepExitCode execute(final ExecutionContext ctx) throws Exception {
                logger.info("Deleting file {}", tempFile);
                LocalFile.valueOf(new File(tempFile)).delete();
                return StepExitCode.SUCCESS;
            }
        }, d);
    }

    private static final Logger logger = LoggerFactory.getLogger(DeployedYakPlaceholders.class);
}
