package com.xebialabs.deployit.plugin.test.yak.ci;

import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;
import com.xebialabs.deployit.plugin.test.yak.step.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("serial")
public class DeployedYakCheckpointFile extends BaseDeployed<YakCheckpointFile, YakServer> {

    private boolean addCheckpoint = true;

    @Create
    public void deploy(DeploymentPlanningContext result, Delta delta) {
        logger.info("Adding deploy step");
        DeployYakFileToServerStep deployYakFileToServerStep = new DeployYakFileToServerStep();
        result.addStep(deployYakFileToServerStep);
        if (addCheckpoint) {
            result.addCheckpoint(deployYakFileToServerStep, delta);
        }
        result.addStep(new FirstTimePauseStep(60));
    }

    @Modify
    public void upgrade(DeploymentPlanningContext result, Delta delta) {
        logger.info("Adding upgrade step");
        UpgradeYakFileOnServerStep step = new UpgradeYakFileOnServerStep();
        result.addStep(step);
        if (addCheckpoint) {
            result.addCheckpoint(step, delta);
        }
        result.addStep(new FirstTimePauseStep(step.getOrder()));
    }

    @Destroy
    public void destroy(DeploymentPlanningContext result, Delta delta) {
        logger.info("Adding undeploy step");
        DeleteYakFileFromServerStep step = new DeleteYakFileFromServerStep();
        result.addStep(step);
        if (addCheckpoint) {
            result.addCheckpoint(step, delta);
        }
        result.addStep(new FirstTimePauseStep(step.getOrder()));
    }

    public boolean isAddCheckpoint() {
        return addCheckpoint;
    }

    public void setAddCheckpoint(final boolean addCheckpoint) {
        this.addCheckpoint = addCheckpoint;
    }

    private static final Logger logger = LoggerFactory.getLogger(DeployedYakCheckpointFile.class);
}
