package com.xebialabs.deployit.plugin.test.v3.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.test.v3.DeployedPortlet;
import com.xebialabs.deployit.plugin.test.v3.DeployedPortletSettings;

@SuppressWarnings("serial")
public class PortletStep implements Step {

    private DeployedPortlet portlet;

    public PortletStep(DeployedPortlet portlet){
        this.portlet = portlet;
    }

    @Override
    public String getDescription() {
        return "Deploy embedded " + portlet.getPortletName();
    }

    @Override
    public StepExitCode execute(final ExecutionContext ctx) throws Exception {
        ctx.logOutput("Deploying " + portlet.getName());

        try {
            for(DeployedPortletSettings settings : portlet.getSettings()){
                ctx.logOutput("mySetting has value: " + settings.getMySetting());
            }
            Thread.sleep(500);
        } catch (InterruptedException e) {
            ctx.logError("Thread.sleep interrupted", e);
            Thread.currentThread().interrupt();
            return StepExitCode.FAIL;
        }

        return StepExitCode.SUCCESS;
    }

    @Override
    public int getOrder() {
        return 0;
    }
}
