package com.xebialabs.deployit.plugin.test.v3.step;

import java.util.Set;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.test.v3.DummyJeeCluster;
import com.xebialabs.deployit.plugin.test.v3.DummyOverthereHost;

import static com.google.common.collect.Sets.newHashSet;

@SuppressWarnings("serial")
public class CreateVirtualHostStep implements Step {

    @SuppressWarnings("unused")
    private final String environmentId;
    private final String hostsLocation;
    private final String hostName;

    public CreateVirtualHostStep(final String environmentId, final String hostsLocation, final String hostName){
        this.environmentId = environmentId;
        this.hostsLocation = hostsLocation;
        this.hostName = hostName;
    }

    @Override
    public int getOrder() {
        return 40;
    }

    @Override
    public String getDescription() {
        return "Creating server: " + hostName;
    }

    @Override
    public StepExitCode execute(final ExecutionContext ctx) throws Exception {
        try {
            Repository repository = ctx.getRepository();

            Set<Host> hosts = (Set) ctx.getAttribute("hosts");
            if(hosts == null) {
                hosts = newHashSet();
            }
            Host host = createDummyHost(repository, hosts);
            createCluster(repository, host);
            ctx.setAttribute("hosts", hosts);

            return StepExitCode.SUCCESS;
        }
        catch(Exception e){
            ctx.logError("Exception while trying to create environment", e);
            return StepExitCode.FAIL;
        }
    }

    private void createCluster(final Repository repository, final Host host) {
        DummyJeeCluster cluster = Type.valueOf(DummyJeeCluster.class).getDescriptor().newInstance(hostsLocation + hostName + "/cloudCluster");
        cluster.setHost(host);
        cluster.setHostName("localhost");
        repository.create(cluster);
    }

    private Host createDummyHost(final Repository repository, final Set<Host> hosts) {
        DummyOverthereHost host = Type.valueOf(DummyOverthereHost.class).getDescriptor().newInstance(hostsLocation + hostName);
        host.setProperty("protocol", "ssh");
        host.setProperty("os", "UNIX");
        host.setTemporaryDirectoryPath("/");
        repository.create(host);
        hosts.add(host);
        return host;
    }

}
