package com.xebialabs.deployit.plugin.test.school;

import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;

import java.util.Set;

import static com.google.common.collect.Sets.newHashSet;

@SuppressWarnings("serial")
public class Student extends BaseDeployed<Child, ClassRoom> {

    @Property
    private String address;

    @Property
    private int iq;

    @Property
    private String studentNumber;

    @Property
    private String course;

    @Property(required = false)
    private Person teacher;

    @Property(required = false, password = true)
    private String loginCode;

    @Property(required = false)
    private String emailAddress;

    @Property(required = false)
    private Set<String> pets = newHashSet();

    public Set<String> getPets() {
        return pets;
    }

    public Person getTeacher() {
        return teacher;
    }

    public String getLoginCode() {
        return loginCode;
    }

    public String getCourse() {
        return course;
    }

    public String getEmailAddress() {
        return emailAddress;
    }

    public void setLoginCode(String loginCode) {
        this.loginCode = loginCode;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setIq(int iq) {
        this.iq = iq;
    }

    public void setStudentNumber(String studentNumber) {
        this.studentNumber = studentNumber;
    }

    public void setCourse(String course) {
        this.course = course;
    }

    public void setTeacher(Person teacher) {
        this.teacher = teacher;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public void setPets(Set<String> pets) {
        this.pets = pets;
    }

    public String getAddress() {
        return address;
    }

    public int getIq() {
        return iq;
    }

    public String getStudentNumber() {
        return studentNumber;
    }
}
