package com.xebialabs.deployit.plugin.test.v3.step;

import com.xebialabs.deployit.plugin.api.flow.*;
import com.xebialabs.deployit.plugin.test.v3.DummyContainer;

@SuppressWarnings("serial")
public abstract class TestStep implements Step {

    protected int stepDelay;
    protected int logAmountInKb;
    protected DummyContainer dummyContainer;

    public TestStep(DummyContainer dummyContainer) {
        if (dummyContainer.getStepDelayTimeInMilliSeconds() < 1) {
            throw new RuntimeException("stepDelayTimeInMilliSeconds retrieved from a test CI of type " + dummyContainer.getClass() + " is less then 1");
        }
        this.dummyContainer = dummyContainer;
        stepDelay = dummyContainer.getStepDelayTimeInMilliSeconds();
        logAmountInKb = dummyContainer.getAmountOfKBLogFiles();
    }

    public TestStep(int stepDelay, int logAmountInKb) {
        this.stepDelay = stepDelay;
        this.logAmountInKb = logAmountInKb;
    }

    public StepExitCode execute(ExecutionContext ctx) {
        final int sleepMillis = 100;
        int amountOfSleeps = stepDelay / sleepMillis;
        int bytesOfLogToGeneratePerSleep = logAmountInKb * 1000 / amountOfSleeps;

        try {
            for (int i = 0; i < amountOfSleeps; i++) {
                Thread.sleep(sleepMillis);
                ctx.logOutput(generateLog(bytesOfLogToGeneratePerSleep));
            }
        } catch (InterruptedException e) {
            ctx.logError("Thread.sleep interrupted", e);
            Thread.currentThread().interrupt();
            return StepExitCode.FAIL;
        }
        return StepExitCode.SUCCESS;
    }

    private static String generateLog(int bytes) {
        String hundredBytes = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam lacinia odio in dui sollicitudin ...\n";
        StringBuilder sb = new StringBuilder();
        sb.append(bytes).append(" bytes: ");
        for (int i = 0; i < bytes / 100; i++) {
            sb.append(hundredBytes);
        }
        return sb.toString();
    }

}