package com.xebialabs.deployit.plugin.test.yak.step;

import java.util.Random;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;

@SuppressWarnings("serial")
public class BreedingStep implements Step {

    private int number;
    private String baseName;

    public BreedingStep(final int number, final String baseName) {
        this.number = number;
        this.baseName = baseName;
    }

    @Override
    public int getOrder() {
        return 40;
    }

    @Override
    public String getDescription() {
        return "Breed Yak: " + getYakName();
    }

    private String getYakName() {
        return baseName + number;
    }

    @Override
    public StepExitCode execute(final ExecutionContext ctx) throws Exception {
        ctx.logOutput("Breeding Yak: " + getYakName());
        ctx.logOutput("Sitting on egg....");
        ctx.logOutput("Egg hatched....");
        ctx.logOutput("And it's a: " + (new Random().nextBoolean() ? "Male" : "Female"));
        return StepExitCode.SUCCESS;
    }
}
