import re
from java.io import BufferedReader
from java.io import ByteArrayInputStream
from java.io import InputStreamReader
from java.lang import StringBuilder
from java.lang import String

###################
def splitFile(stream):
    reader = BufferedReader(InputStreamReader(stream))
    out = StringBuilder()

    while True:
        line = reader.readLine()
        if line is None:
            break
        out.append(line)
        out.append("\n")

    reader.close()
    splitted = re.split('---', out.toString())
    return splitted

def stringify(stream):
    reader = BufferedReader(InputStreamReader(stream))
    out = StringBuilder()

    while True:
        line = reader.readLine()
        if line is None:
            break
        out.append(line)
        out.append("\n")

    reader.close()
    return out.toString()


###################

if deployed:
    yaml_list = splitFile(deployed.file.getInputStream())

    items = []
    for idx, item in enumerate(yaml_list):
        item_stream = ByteArrayInputStream(String(item).getBytes())

        stitchedContent = stitch(item_stream)

        step = steps.jython(
            description="Deploying part {0} of initial deployed".format(idx + 1),
            script="yak/step/stitchstep.py",
            jython_context={"data": stringify(stitchedContent)},
            order=50,
            preview_script="yak/preview/stitchpreview.py")

        context.addStep(step)
