/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.test.v3.step;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.test.v3.DummyJeeCluster;
import com.xebialabs.deployit.plugin.test.v3.DummyOverthereHost;
import java.util.Set;

public class CreateVirtualHostStep
implements Step {
    private final String environmentId;
    private final String hostsLocation;
    private final String hostName;

    public CreateVirtualHostStep(String environmentId, String hostsLocation, String hostName) {
        this.environmentId = environmentId;
        this.hostsLocation = hostsLocation;
        this.hostName = hostName;
    }

    public int getOrder() {
        return 40;
    }

    public String getDescription() {
        return "Creating server: " + this.hostName;
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        try {
            Repository repository = ctx.getRepository();
            Set hosts = (Set)ctx.getAttribute("hosts");
            if (hosts == null) {
                hosts = Sets.newHashSet();
            }
            Host host = this.createDummyHost(repository, hosts);
            this.createCluster(repository, host);
            ctx.setAttribute("hosts", (Object)hosts);
            return StepExitCode.SUCCESS;
        }
        catch (Exception e) {
            ctx.logError("Exception while trying to create environment", (Throwable)e);
            return StepExitCode.FAIL;
        }
    }

    private void createCluster(Repository repository, Host host) {
        DummyJeeCluster cluster = (DummyJeeCluster)Type.valueOf(DummyJeeCluster.class).getDescriptor().newInstance(this.hostsLocation + this.hostName + "/cloudCluster");
        cluster.setHost((Container)host);
        cluster.setHostName("localhost");
        repository.create((ConfigurationItem[])new DummyJeeCluster[]{cluster});
    }

    private Host createDummyHost(Repository repository, Set<Host> hosts) {
        DummyOverthereHost host = (DummyOverthereHost)Type.valueOf(DummyOverthereHost.class).getDescriptor().newInstance(this.hostsLocation + this.hostName);
        host.setProperty("protocol", "ssh");
        host.setProperty("os", "UNIX");
        host.setTemporaryDirectoryPath("/");
        repository.create((ConfigurationItem[])new DummyOverthereHost[]{host});
        hosts.add(host);
        return host;
    }
}

