/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.test.yak.ci;

import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployedArtifact;
import com.xebialabs.deployit.plugin.test.yak.ci.YakServer;
import com.xebialabs.deployit.plugin.test.yak.ci.YakStitchFile;
import com.xebialabs.deployit.plugin.test.yak.step.DeleteYakFileFromServerStep;
import com.xebialabs.deployit.plugin.test.yak.step.StartDeployedYakStitchFileStep;
import com.xebialabs.deployit.plugin.test.yak.step.UpgradeYakFileOnServerStep;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployedYakStitchFile
extends BaseDeployedArtifact<YakStitchFile, YakServer> {
    private static final Logger logger = LoggerFactory.getLogger(DeployedYakStitchFile.class);

    @Create
    public void deploy(DeploymentPlanningContext result) {
        logger.info("Adding start artifact");
        result.addStep((Step)new StartDeployedYakStitchFileStep(this));
    }

    @Modify
    public void upgrade(DeploymentPlanningContext result, Delta delta) {
        logger.info("Adding upgrade step");
        DeployedYakStitchFile previous = (DeployedYakStitchFile)delta.getPrevious();
        previous.destroy(result);
        result.addStep((Step)new UpgradeYakFileOnServerStep());
    }

    @Destroy
    public void destroy(DeploymentPlanningContext result) {
        logger.info("Adding undeploy step");
        result.addStep((Step)new DeleteYakFileFromServerStep());
    }

    public boolean hasUnresolvedPlaceholders(ExecutionContext ctx) {
        try {
            TaskSpecification task = (TaskSpecification)ctx.getAttribute("taskExecutionContext");
            Pattern placeholderRegex = Pattern.compile("[{]{2}\\w+[}]{2}");
            for (StepState step : task.getBlock().getStepList()) {
                if (!placeholderRegex.matcher(step.getLog()).find()) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

