/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin;

import com.xebialabs.deployit.plugin.BasePatchDictionary;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ScalaSignature;

@Metadata(root=Metadata.ConfigurationItemRoot.ENVIRONMENTS, description="A Patch Dictionary contains Environment-specific entries for non-intrusive dictionary value resolution")
@ScalaSignature(bytes="\u0006\u0005\u0005]a\u0001B\b\u0011\u0001eAQ\u0001\u000b\u0001\u0005\u0002%Bqa\u000b\u0001A\u0002\u0013\u0005A\u0006C\u0004;\u0001\u0001\u0007I\u0011A\u001e\t\r\t\u0003\u0001\u0015)\u0003.\u0011\u001di\u0005\u00011A\u0005\u00021BqA\u0014\u0001A\u0002\u0013\u0005q\n\u0003\u0004R\u0001\u0001\u0006K!\f\u0005\b+\u0002\u0001\r\u0011\"\u0001-\u0011\u001d1\u0006\u00011A\u0005\u0002]Ca!\u0017\u0001!B\u0013i\u0003\"B2\u0001\t\u0003\"\u0007\"\u0002;\u0001\t\u0003)\b\"B<\u0001\t\u0003A\b\"\u0002>\u0001\t\u0003Y(\u0001\u0006*fO\u0016D\b+\u0019;dQ\u0012K7\r^5p]\u0006\u0014\u0018P\u0003\u0002\u0012%\u00051\u0001\u000f\\;hS:T!a\u0005\u000b\u0002\u0011\u0011,\u0007\u000f\\8zSRT!!\u0006\f\u0002\u0013a,'-[1mC\n\u001c(\"A\f\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001QB\u0005\u0005\u0002\u001cE5\tAD\u0003\u0002\u001e=\u0005!!-Y:f\u0015\ty\u0002%A\u0002vI6T!!\t\t\u0002\u0007\u0005\u0004\u0018.\u0003\u0002$9\t)\")Y:f\u0007>tg-[4ve\u0006$\u0018n\u001c8Ji\u0016l\u0007CA\u0013'\u001b\u0005\u0001\u0012BA\u0014\u0011\u0005M\u0011\u0015m]3QCR\u001c\u0007\u000eR5di&|g.\u0019:z\u0003\u0019a\u0014N\\5u}Q\t!\u0006\u0005\u0002&\u0001\u0005)!/Z4fqV\tQ\u0006\u0005\u0002/o9\u0011q&\u000e\t\u0003aMj\u0011!\r\u0006\u0003ea\ta\u0001\u0010:p_Rt$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a\u0014A\u0002)sK\u0012,g-\u0003\u00029s\t11\u000b\u001e:j]\u001eT!AN\u001a\u0002\u0013I,w-\u001a=`I\u0015\fHC\u0001\u001fA!\tid(D\u00014\u0013\ty4G\u0001\u0003V]&$\bbB!\u0004\u0003\u0003\u0005\r!L\u0001\u0004q\u0012\n\u0014A\u0002:fO\u0016D\b\u0005\u000b\u0004\u0005\t\"K5\n\u0014\t\u0003\u000b\u001ak\u0011AH\u0005\u0003\u000fz\u0011\u0001\u0002\u0015:pa\u0016\u0014H/_\u0001\fI\u0016\u001c8M]5qi&|g.I\u0001K\u0003=!\u0006.\u001a\u0011SK\u001e,\u0007\u0010\t9bi\u000eD\u0017\u0001\u0003:fcVL'/\u001a3\u001a\u0003\u0005\tAb];cgRLG/\u001e;j_:\f\u0001c];cgRLG/\u001e;j_:|F%Z9\u0015\u0005q\u0002\u0006bB!\u0007\u0003\u0003\u0005\r!L\u0001\u000egV\u00147\u000f^5ukRLwN\u001c\u0011)\r\u001d!\u0005jU&MC\u0005!\u0016\u0001\u0005+iK\u0002\u001aXOY:uSR,H/[8o\u0003M\t7\r^5wCRLwN\u001c$jY\u0016\u0014VmZ3y\u0003]\t7\r^5wCRLwN\u001c$jY\u0016\u0014VmZ3y?\u0012*\u0017\u000f\u0006\u0002=1\"9\u0011)CA\u0001\u0002\u0004i\u0013\u0001F1di&4\u0018\r^5p]\u001aKG.\u001a*fO\u0016D\b\u0005\u000b\u0006\u000b\t\"[6\nT/_A\u0006\f\u0013\u0001X\u0001\u001f\u0003\u000e$\u0018N^1uS>t\u0007EY=!M&dWM\\1nK\u0002B#+Z4fq&\n\u0001bY1uK\u001e|'/_\u0011\u0002?\u0006Q\u0011m\u0019;jm\u0006$xN]:\u0002\u0019\u0011,g-Y;miZ\u000bG.^3\"\u0003\t\f!A\f\u0016\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007\u0015lw\u000e\u0005\u0002gW6\tqM\u0003\u0002iS\u0006\u0011\u0011n\u001c\u0006\u0002U\u0006!!.\u0019<b\u0013\tawMA\u0006J]B,Ho\u0015;sK\u0006l\u0007\"\u00028\f\u0001\u0004)\u0017aC5oaV$8\u000b\u001e:fC6DQ\u0001]\u0006A\u0002E\f!aY5\u0011\u0005\u0015\u0013\u0018BA:\u001f\u0005E\u0019uN\u001c4jOV\u0014\u0018\r^5p]&#X-\\\u0001\tg\u0016$(+Z4fqR\u0011AH\u001e\u0005\u0006W1\u0001\r!L\u0001\u0010g\u0016$8+\u001e2ti&$X\u000f^5p]R\u0011A(\u001f\u0005\u0006\u001b6\u0001\r!L\u0001\u0017g\u0016$\u0018i\u0019;jm\u0006$\u0018n\u001c8GS2,'+Z4fqR\u0011A\b \u0005\u0006+:\u0001\r!\f\u0015\n\u0001y\f\u0019!!\u0002I\u0003'\u0001\"!R@\n\u0007\u0005\u0005aD\u0001\u0005NKR\fG-\u0019;b\u0003\u0011\u0011xn\u001c;%\u0005\u0005\u001d\u0011\u0002BA\u0005\u0003\u0017\tA\"\u0012(W\u0013J{e*T#O)NSA!!\u0004\u0002\u0010\u0005)2i\u001c8gS\u001e,(/\u0019;j_:LE/Z7S_>$(bAA\t=\u0005AQ*\u001a;bI\u0006$\u0018-\t\u0002\u0002\u0016\u00051\u0017\t\t)bi\u000eD\u0007\u0005R5di&|g.\u0019:zA\r|g\u000e^1j]N\u0004SI\u001c<je>tW.\u001a8u[M\u0004XmY5gS\u000e\u0004SM\u001c;sS\u0016\u001c\bEZ8sA9|g.L5oiJ,8/\u001b<fA\u0011L7\r^5p]\u0006\u0014\u0018\u0010\t<bYV,\u0007E]3t_2,H/[8o\u0001")
public class RegexPatchDictionary
extends BaseConfigurationItem
implements BasePatchDictionary {
    @Property(description="The Regex patch", required=true)
    private String regex = "";
    @Property(description="The substitution", required=true)
    private String substitution = "";
    @Property(description="Activation by filename (Regex)", required=true, category="activators", defaultValue=".*")
    private String activationFileRegex = ".*";

    public String regex() {
        return this.regex;
    }

    public void regex_$eq(String x$1) {
        this.regex = x$1;
    }

    public String substitution() {
        return this.substitution;
    }

    public void substitution_$eq(String x$1) {
        this.substitution = x$1;
    }

    public String activationFileRegex() {
        return this.activationFileRegex;
    }

    public void activationFileRegex_$eq(String x$1) {
        this.activationFileRegex = x$1;
    }

    public InputStream apply(InputStream inputStream, ConfigurationItem ci) {
        if (ci != null && ci.getType().instanceOf(Type.valueOf(DeployableArtifact.class))) {
            DeployableArtifact artifact = (DeployableArtifact)ci;
            String filename = artifact.getFile().getName();
            if (filename.matches(this.activationFileRegex())) {
                String string = Source$.MODULE$.fromInputStream(inputStream, Codec$.MODULE$.fallbackSystemCodec()).mkString();
                return new ByteArrayInputStream(string.replaceAll(this.regex(), this.substitution()).getBytes());
            }
            return inputStream;
        }
        return inputStream;
    }

    public void setRegex(String regex) {
        this.regex_$eq(regex);
    }

    public void setSubstitution(String substitution) {
        this.substitution_$eq(substitution);
    }

    public void setActivationFileRegex(String activationFileRegex) {
        this.activationFileRegex_$eq(activationFileRegex);
    }
}

