package com.xebialabs.deployit.plugin

import java.io.{ByteArrayInputStream, InputStream}

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.ENVIRONMENTS
import com.xebialabs.deployit.plugin.api.udm.{ConfigurationItem, DeployableArtifact, Metadata, Property}

@Metadata(root = ENVIRONMENTS, description = "A Patch Dictionary contains Environment-specific entries for non-intrusive dictionary value resolution")
class RegexPatchDictionary extends BasePatchDictionary {

  @Property(description = "The Regex patch", required = true)
  var regex: String = ""

  @Property(description = "The substitution", required = true)
  var substitution: String = ""

  @Property(description = "Activation by filename (Regex)", required = true, category = "activators", defaultValue = ".*")
  var activationFileRegex: String = ".*"

  override def apply(inputStream: InputStream, ci: ConfigurationItem): InputStream = {
    if (ci != null && ci.getType.instanceOf(Type.valueOf(classOf[DeployableArtifact]))) {
      val artifact = ci.asInstanceOf[DeployableArtifact]
      val filename = artifact.getFile.getName
      if (filename.matches(activationFileRegex)) {
        val string = scala.io.Source.fromInputStream(inputStream).mkString
        new ByteArrayInputStream(string.replaceAll(regex, substitution).getBytes())
      } else {
        inputStream
      }
    } else {
      inputStream
    }
  }

  def setRegex(regex: String): Unit = this.regex = regex

  def setSubstitution(substitution: String): Unit = this.substitution = substitution

  def setActivationFileRegex(activationFileRegex: String): Unit = this.activationFileRegex = activationFileRegex
}