package ai.digital.deploy.webhook

import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}

import scala.beans.BeanProperty

@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION, description = "Defines Webhook server with authentication options.")
class WebhookServer extends BaseConfigurationItem {
  @BeanProperty
  @Property(label = "API server URL", required = true, description = "URL for Webhook API endpoint")
  var webhookServerURL: String = _

  @BeanProperty
  @Property(label = "Enabled", defaultValue = "true", description = "Enables or disable this Webhook. Disabled Webhooks won't send any notification to the endpoint.")
  var enabled = false

  @BeanProperty
  @Property(label = "Turn off authentication", defaultValue = "false", description = "Disables sending of authentication token if true", category = "Authentication")
  var noAuthentication = false

  @BeanProperty
  @Property(label = "Token header", required = false, description = "Authentication token HTTP request header.", category = "Authentication")
  var tokenHeader: String = _

  @BeanProperty
  @Property(label = "Token value", required = false, password = true, description = "Authentication token HTTP request value.", category = "Authentication")
  var tokenValue: String = _

  @BeanProperty
  @Property(required = true, description = "Application/directory path/regex in Digital.ai Deploy")
  var application: String = _

  @BeanProperty
  @Property(required = true, description = "Environment/directory path/regex in Digital.ai Deploy")
  var environment: String = _
}

