package com.xebialabs.deployit.plugin.trigger;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;

import java.util.Set;

import static com.google.common.collect.Sets.newHashSet;

public enum TaskState implements TriggerState<TaskExecutionState> {

    ANY(null,null),

    QUEUED(TaskExecutionState.QUEUED, newHashSet(TaskExecutionState.EXECUTING)),

    PENDING(TaskExecutionState.PENDING, newHashSet(TaskExecutionState.QUEUED,
                                                    TaskExecutionState.SCHEDULED)),

    EXECUTING(TaskExecutionState.EXECUTING, newHashSet(TaskExecutionState.EXECUTED,
                                                        TaskExecutionState.FAILING,
                                                        TaskExecutionState.STOPPING,
                                                        TaskExecutionState.ABORTING,
                                                        TaskExecutionState.FAILED,
                                                        TaskExecutionState.STOPPED,
                                                        TaskExecutionState.ABORTED)),

    DONE(TaskExecutionState.DONE, Sets.<TaskExecutionState>newHashSet()),

    STOPPED(TaskExecutionState.STOPPED, newHashSet(TaskExecutionState.SCHEDULED,
                                                    TaskExecutionState.CANCELLED,
                                                    TaskExecutionState.QUEUED)),

    EXECUTED(TaskExecutionState.EXECUTED, newHashSet(TaskExecutionState.DONE)),

    CANCELLED(TaskExecutionState.CANCELLED, Sets.<TaskExecutionState>newHashSet()),

    // New states added with TaskExecutionState
    FAILING(TaskExecutionState.FAILING, newHashSet(TaskExecutionState.FAILED,
                                                    TaskExecutionState.ABORTING)),

    FAILED(TaskExecutionState.FAILED, newHashSet(TaskExecutionState.SCHEDULED,
                                                  TaskExecutionState.CANCELLED,
                                                  TaskExecutionState.QUEUED)),

    STOPPING(TaskExecutionState.STOPPING, newHashSet(TaskExecutionState.STOPPED,
                                                      TaskExecutionState.ABORTING)),

    ABORTING(TaskExecutionState.ABORTING, newHashSet(TaskExecutionState.ABORTED)),

    ABORTED(TaskExecutionState.ABORTED, newHashSet(TaskExecutionState.SCHEDULED,
                                                    TaskExecutionState.CANCELLED,
                                                    TaskExecutionState.QUEUED)),

    SCHEDULED(TaskExecutionState.SCHEDULED, newHashSet(TaskExecutionState.QUEUED,
                                                        TaskExecutionState.SCHEDULED))
    ;



    private TaskExecutionState taskExecutionState;
    private Set<TaskExecutionState> validToTransition;

    private TaskState(TaskExecutionState taskExecutionState, Set<TaskExecutionState> validToTransition) {
        this.taskExecutionState = taskExecutionState;
        this.validToTransition = validToTransition;
    }

    public boolean equivalentTo(TaskExecutionState spiState) {
        if (spiState == null) {
            return false;
        }
        return (taskExecutionState == null) || (taskExecutionState == spiState);
    }

    public boolean isValidTransition(TaskState toState) {
        if (taskExecutionState == null || toState.taskExecutionState == null) {  //ANY state
            return true;
        }

        return validToTransition.contains(toState.taskExecutionState);
    }
}
