/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.trigger.contrib;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.engine.api.execution.StepExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.spi.execution.NonRemotableExecutionStateListener;
import com.xebialabs.deployit.engine.spi.execution.StepExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.trigger.Action;
import com.xebialabs.deployit.plugin.trigger.StepTrigger;
import com.xebialabs.deployit.plugin.trigger.TaskTrigger;
import com.xebialabs.deployit.plugin.trigger.Trigger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerExecutionListener
implements NonRemotableExecutionStateListener {
    private List<Trigger> allTriggers;
    private final Deltas deltas;
    private final DeployedApplication deployedApplication;
    private static Logger logger = LoggerFactory.getLogger(TriggerExecutionListener.class);

    public TriggerExecutionListener(List<Trigger> triggers, Deltas deltas, DeployedApplication deployedApplication) {
        logger.debug("TriggerExecutionListener instantiated for deployed application {}", (Object)deployedApplication);
        this.allTriggers = triggers;
        this.deltas = deltas;
        this.deployedApplication = deployedApplication;
    }

    public void stepStateChanged(StepExecutionStateEvent event) {
        logger.debug("Received step execution state event {}", (Object)event);
        Iterable stepTriggers = Iterables.filter(this.allTriggers, new FireTriggerPredicate<StepExecutionState>(StepTrigger.class, event.previousState(), event.currentState()));
        HashMap commonCtx = Maps.newHashMap();
        commonCtx.put("task", event.task());
        commonCtx.put("step", event.step());
        this.executeTriggers(stepTriggers, commonCtx);
    }

    public void taskStateChanged(TaskExecutionStateEvent event) {
        logger.debug("Received task execution state event {}", (Object)event);
        Iterable taskTriggers = Iterables.filter(this.allTriggers, new FireTriggerPredicate<TaskExecutionState>(TaskTrigger.class, event.previousState(), event.currentState()));
        HashMap commonCtx = Maps.newHashMap();
        commonCtx.put("task", event.task());
        this.executeTriggers(taskTriggers, commonCtx);
    }

    protected void executeTriggers(Iterable<Trigger> triggers, Map<String, Object> commonCtx) {
        commonCtx.put("deltas", this.deltas);
        commonCtx.put("deployedApplication", this.deployedApplication);
        Iterable actions = Iterables.concat((Iterable)Iterables.transform(triggers, (Function)new Function<Trigger, Iterable<Action>>(this){

            public Iterable<Action> apply(Trigger input) {
                return input.getActions();
            }
        }));
        for (Action action : actions) {
            logger.debug("Executing action {}", (Object)action);
            HashMap ctx = Maps.newHashMap(commonCtx);
            ctx.put("action", action);
            action.execute(ctx);
        }
    }

    static class FireTriggerPredicate<T>
    implements Predicate<Trigger> {
        private Class<?> triggerType;
        private T fromState;
        private T toState;

        public FireTriggerPredicate(Class<?> triggerType, T fromState, T toState) {
            this.triggerType = triggerType;
            this.fromState = fromState;
            this.toState = toState;
        }

        public boolean apply(Trigger input) {
            return this.triggerType.isInstance((Object)input) && input.getFromState().equivalentTo(this.fromState) && input.getToState().equivalentTo(this.toState);
        }
    }
}

