package com.xebialabs.deployit.plugin.remoting.preview;

import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.Overthere;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.spi.BaseOverthereConnection;
import com.xebialabs.overthere.spi.OverthereConnectionBuilder;
import com.xebialabs.overthere.spi.Protocol;

import java.util.HashSet;
import java.util.Set;

import static com.xebialabs.overthere.ConnectionOptions.OPERATING_SYSTEM;
import static com.xebialabs.overthere.ConnectionOptions.TEMPORARY_DIRECTORY_PATH;
import static com.xebialabs.overthere.OperatingSystemFamily.getLocalHostOperatingSystemFamily;

@Protocol(name = PreviewOverthereConnection.PREVIEW_PROTOCOL)
public class PreviewOverthereConnection extends BaseOverthereConnection implements OverthereConnectionBuilder {

    public static final String PREVIEW_PROTOCOL = "preview";

    private final Set<String> seenPaths = new HashSet<>();

    public PreviewOverthereConnection(String protocol, ConnectionOptions options, AddressPortMapper mapper) {
        super(protocol, fixOptions(options), mapper, false);
    }

    private static ConnectionOptions fixOptions(ConnectionOptions options) {
        options = new ConnectionOptions(options);
        options.set(OPERATING_SYSTEM, getLocalHostOperatingSystemFamily());
        if (options.getOptional(TEMPORARY_DIRECTORY_PATH) == null) {
            options.set(TEMPORARY_DIRECTORY_PATH, System.getProperty("java.io.tmpdir"));
        }
        return options;
    }

    @Override
    public OverthereConnection connect() {
        return this;
    }

    @Override
    protected void doClose() {
    }

    @Override
    public OverthereFile getFile(String hostPath) {
        return new PreviewOverthereFile(this, hostPath);
    }

    @Override
    public OverthereFile getFile(OverthereFile parent, String child) {
        return parent.getFile(child);
    }

    @Override
    protected OverthereFile getFileForTempFile(OverthereFile parent, String name) {
        return parent.getFile(name);
    }

    @Override
    public String toString() {
        return PREVIEW_PROTOCOL + ":";
    }

    public static OverthereConnection getPreviewConnection() {
        return Overthere.getConnection(PREVIEW_PROTOCOL, new ConnectionOptions());
    }

    void createDir(PreviewOverthereFile dir) {
        markPathAsSeen(dir.getPath());
    }

    void markPathAsSeen(String path) {
        seenPaths.add(path);
    }

    void removeDirFromSeenPath(PreviewOverthereFile dir) {
        seenPaths.remove(dir.getPath());
    }

    boolean isPathSeen(PreviewOverthereFile file) {
        return seenPaths.contains(file.getPath());
    }
}
