package com.xebialabs.deployit.plugin.overthere;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Delegate;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import com.xebialabs.deployit.plugin.overthere.step.ZosCheckCommandExecutionStep;
import com.xebialabs.deployit.plugin.overthere.step.ZosCheckFileTransferStep;
import com.xebialabs.deployit.plugin.overthere.step.ZosCheckFileEncoding;
import com.xebialabs.overthere.ssh.SshConnectionType;
import com.xebialabs.overthere.ssh.SshZosConnectionType;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import static com.xebialabs.deployit.checks.Checks.checkArgument;

public class ZosCheckConnectionDelegate {

    private static final Logger log = Logger.getLogger(ZosCheckConnectionDelegate.class);

    private ZosCheckConnectionDelegate() {}

    @Delegate(name = "zosConnectionChecker")
    public static List<Step> executedScriptDelegate(ConfigurationItem item, String name, Map<String, String> args, Parameters params) {
        checkArgument(item instanceof Host, "the connectionChecker delegate is for 'overthere.Host' subtypes only");
        ArrayList<Step> zosCheckConnectionSteps;

        if (!(item.hasProperty("zosConnectionType") &&
                item.getProperty("zosConnectionType") != null &&
                item.getProperty("zosConnectionType") == SshZosConnectionType.SFTP)) {
            log.error("ZOSCONN: The zosConnectionType is not initialized expecting SFTP "+item.getProperty("zosConnectionType"));
            zosCheckConnectionSteps = new ArrayList<>();
            return zosCheckConnectionSteps;
        }

        if (item.hasProperty("connectionType") &&
                item.getProperty("connectionType") != null &&
                item.getProperty("connectionType") == SshConnectionType.SFTP) {

            zosCheckConnectionSteps = newStepsForSFTP((Host) item);
            zosCheckConnectionSteps.add(new ZosCheckFileEncoding((Host) item));

        } else {
            zosCheckConnectionSteps = new ArrayList<>();
            log.error("ZOSCONN: The connectionType is not initialized expecting SFTP DEFAULT "+item.getProperty("connectionType"));
        }
        return zosCheckConnectionSteps;
    }

    private static ArrayList<Step> newStepsForSFTP(Host item) {
        return Lists.newArrayList(
                new ZosCheckFileTransferStep(item),
                new ZosCheckCommandExecutionStep(item));
    }

}
