package com.xebialabs.deployit.plugin.overthere.step;

import com.xebialabs.deployit.plugin.overthere.Host;

import static com.xebialabs.overthere.ConnectionOptions.ADDRESS;

public class ZosCheckFileTransferStep extends CheckFileTransferStep {

    private final String hostname;
    private final String connectionType;

    public ZosCheckFileTransferStep(Host host) {
        super(host);
        this.connectionType = host.getProperty("connectionType").toString();
        if (host.hasProperty(ADDRESS)) {
            this.hostname = host.getProperty(ADDRESS);
        } else {
            this.hostname = host.getName();
        }
        host.setProperty("connectionType", connectionType);
    }

    @Override
    public String getDescription() {
        return "Check whether XL Deploy can transfer files to " + hostname + " using " + connectionType;
    }

    public String getConnectionType() {
        return connectionType;
    }
}
