package com.xebialabs.deployit.plugin.overthere;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;

/**
 * An {@link AutoFlushingProcessOutputHandler} that logs the output to a {@link ExecutionContext}.
 */
public class DefaultProcessOutputHandler extends AutoFlushingProcessOutputHandler {

    private ExecutionContext ctx;

    public DefaultProcessOutputHandler(ExecutionContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public void handleErrorLine(String line) {
        ctx.logError(line);
    }

    @Override
    protected void handleOutput(String buffer) {
        ctx.logOutput(buffer);
    }

}
