/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.overthere.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import com.xebialabs.xlplatform.satellite.Satellite;
import com.xebialabs.xlplatform.satellite.SatelliteAware;

public class ZosCheckFileEncoding
implements SatelliteAware {
    private Host host;
    private String hostname;

    public ZosCheckFileEncoding(Host host) {
        this.host = host;
        this.hostname = host.hasProperty("address") ? (String)host.getProperty("address") : host.getName();
    }

    public String getDescription() {
        return "Check file encoding available on " + this.hostname;
    }

    public int getOrder() {
        return 50;
    }

    public Satellite getSatellite() {
        return this.host.getSatellite();
    }

    /*
     * Exception decompiling
     */
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 24[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkConnection(ExecutionContext ctx, OverthereConnection connection, OverthereExecutionOutputHandler stdoutHandler, OverthereExecutionOutputHandler stderrHandler) {
        if (this.echoDefaultEncoding(connection, stdoutHandler, stderrHandler, ctx) != 0 || this.grepSpecificFileEncodingFormat(connection, stdoutHandler, stderrHandler, ctx) != 0) {
            ctx.logError("Failed to execute command. Please check the logs.");
        }
    }

    private int echoDefaultEncoding(OverthereConnection connection, OverthereExecutionOutputHandler stdoutHandler, OverthereExecutionOutputHandler stderrHandler, ExecutionContext ctx) {
        ctx.logOutput("Default encoding format that is currently used - ");
        CmdLine cmdLine = new CmdLine();
        if (connection.getHostOperatingSystem() == OperatingSystemFamily.WINDOWS) {
            cmdLine.addArgument("chcp");
        } else {
            cmdLine.addArgument("echo");
            cmdLine.addRaw("$LANG");
        }
        return connection.execute(stdoutHandler, stderrHandler, cmdLine);
    }

    private int grepSpecificFileEncodingFormat(OverthereConnection connection, OverthereExecutionOutputHandler stdoutHandler, OverthereExecutionOutputHandler stderrHandler, ExecutionContext ctx) {
        CmdLine cmdLine;
        if (connection.getHostOperatingSystem() == OperatingSystemFamily.WINDOWS) {
            ctx.logOutput(" ");
            ctx.logOutput("Checking if UTF-8 and CP1047 are supported...");
            cmdLine = this.buildWindowsGrepCommandSimple(connection);
        } else {
            ctx.logOutput(" ");
            ctx.logOutput("Checking if CP1047 is supported on " + this.hostname + "...");
            cmdLine = new CmdLine().addArgument("iconv").addArgument("-l").addRaw("|").addArgument("grep").addArgument("CP1047");
        }
        return connection.execute(stdoutHandler, stderrHandler, cmdLine);
    }

    private CmdLine buildWindowsGrepCommandSimple(OverthereConnection connection) {
        return new CmdLine().addArgument("chcp").addArgument("65001").addRaw("&&").addArgument("echo").addArgument("UTF-8").addArgument("is").addArgument("supported").addRaw("||").addArgument("echo").addArgument("UTF-8").addArgument("is").addArgument("not").addArgument("supported").addRaw("&").addArgument("echo").addArgument("CP1047").addArgument("is").addArgument("supported").addRaw("||").addArgument("echo").addArgument("CP1047").addArgument("is").addArgument("not").addArgument("supported");
    }
}

