package com.xebialabs.deployit.plugin.credentials.gcp;

import java.util.function.BiConsumer;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;

import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION;

@Metadata(root = CONFIGURATION, description = "Credentials for Service Account from properties")
public class ServiceAccountPkcs8GcpCredentials extends GcpHostCredentials {
    @Property(label = "Project ID")
    private String  projectId;
    @Property(label = "Client ID of the service account")
    private String clientId;
    @Property(label = "Client email address of the service account")
    private String clientEmail;
    @Property(label = "RSA private key object for the service account in PKCS#8 format", size = Property.Size.LARGE)
    private String privateKeyPkcs8;
    @Property(label = "Private key identifier for the service account")
    private String privateKeyId;
    @Property(label = "Scopes, comma separated list, for the APIs to be called", required = false)
    private String scopes;
    @Property(label = "URI of the end point that provides tokens", required = false)
    private String tokenServerUri;
    @Property(label = "The email of the user account to impersonate, if delegating domain-wide authority to the service account", required = false)
    private String serviceAccountUser;

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(final String projectId) {
        this.projectId = projectId;
    }

    public String getClientId() {
        return clientId;
    }

    public void setClientId(final String clientId) {
        this.clientId = clientId;
    }

    public String getClientEmail() {
        return clientEmail;
    }

    public void setClientEmail(final String clientEmail) {
        this.clientEmail = clientEmail;
    }

    public String getPrivateKeyPkcs8() {
        return privateKeyPkcs8;
    }

    public void setPrivateKeyPkcs8(final String privateKeyPkcs8) {
        this.privateKeyPkcs8 = privateKeyPkcs8;
    }

    public String getPrivateKeyId() {
        return privateKeyId;
    }

    public void setPrivateKeyId(final String privateKeyId) {
        this.privateKeyId = privateKeyId;
    }

    public String getScopes() {
        return scopes;
    }

    public void setScopes(final String scopes) {
        this.scopes = scopes;
    }

    public String getTokenServerUri() {
        return tokenServerUri;
    }

    public void setTokenServerUri(final String tokenServerUri) {
        this.tokenServerUri = tokenServerUri;
    }

    public String getServiceAccountUser() {
        return serviceAccountUser;
    }

    public void setServiceAccountUser(final String serviceAccountUser) {
        this.serviceAccountUser = serviceAccountUser;
    }

    public void applyProperties(BiConsumer<String, String> consumer) {
        super.applyProperties(consumer);
        consumer.accept("gcpCredentialsType", "ServiceAccountPkcs8");
        consumer.accept("projectId", getProjectId());
        consumer.accept("clientId", getClientId());
        consumer.accept("clientEmail", getClientEmail());
        consumer.accept("privateKeyPkcs8", getPrivateKeyPkcs8());
        consumer.accept("privateKeyId", getPrivateKeyId());
        consumer.accept("scopes", getScopes());
        if (getTokenServerUri() != null) {
            consumer.accept("tokenServerUri", getTokenServerUri());
        } else {
            consumer.accept("tokenServerUri", "https://oauth2.googleapis.com/token");
        }
        consumer.accept("serviceAccountUser", getServiceAccountUser());
    }
}
