package com.xebialabs.deployit.plugin.credentials.gcp;

import java.util.function.BiConsumer;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;

import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION;

@Metadata(root = CONFIGURATION, description = "Default Credentials Service Account from xl-deploy environment")
public class DefaultGcpCredentials extends GcpHostCredentials {
    @Property(label = "Project ID")
    private String projectId;
    @Property(label = "Client email address of the service account")
    private String clientEmail;

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(final String projectId) {
        this.projectId = projectId;
    }

    public String getClientEmail() {
        return clientEmail;
    }

    public void setClientEmail(final String clientEmail) {
        this.clientEmail = clientEmail;
    }

    public void applyProperties(BiConsumer<String, String> consumer) {
        super.applyProperties(consumer);
        consumer.accept("gcpCredentialsType", "Default");
        consumer.accept("projectId", getProjectId());
        consumer.accept("clientEmail", getClientEmail());
    }
}
