package com.xebialabs.deployit.plugin.overthere.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.overthere.DefaultExecutionOutputHandler;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.*;
import com.xebialabs.overthere.local.LocalConnection;
import com.xebialabs.xlplatform.satellite.Satellite;
import com.xebialabs.xlplatform.satellite.SatelliteAware;

import static com.xebialabs.deployit.plugin.overthere.DefaultExecutionOutputHandler.handleStderr;
import static com.xebialabs.deployit.plugin.overthere.DefaultExecutionOutputHandler.handleStdout;
import static com.xebialabs.overthere.ConnectionOptions.ADDRESS;
import static com.xebialabs.overthere.OperatingSystemFamily.WINDOWS;

public class ZosCheckFileEncoding implements SatelliteAware {

    private Host host;

    private String hostname;

    public ZosCheckFileEncoding(Host host) {
        this.host = host;
        if (host.hasProperty(ADDRESS)) {
            this.hostname = host.getProperty(ADDRESS);
        } else {
            this.hostname = host.getName();
        }
    }

    @Override
    public String getDescription() {
        return "Check file encoding available on " + hostname;
    }

    @Override
    public int getOrder() {
        return 50;
    }

    @Override
    public Satellite getSatellite() {
        return host.getSatellite();
    }


    @Override
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        try (DefaultExecutionOutputHandler stdoutHandler = handleStdout(ctx);
             DefaultExecutionOutputHandler stderrHandler = handleStderr(ctx);
             OverthereConnection destination = host.getConnection();
             OverthereConnection source = LocalConnection.getLocalConnection()) {

            // Check Connection for target machine
            ctx.logOutput("Checking file encoding available on " + hostname + "...");
            ctx.logOutput(" ");
            checkConnection(ctx, destination, stdoutHandler, stderrHandler);

            // Check Connection for localhost when OS is Windows
            //FIXME Add log for linux after fixed in overthere
            if (source.getHostOperatingSystem() == WINDOWS) {
                ctx.logOutput(" ");
                ctx.logOutput("Checking file encoding available on localhost...");
                ctx.logOutput(" ");
                checkConnection(ctx, source, stdoutHandler, stderrHandler);
            }

            // FIXME with story S-118275
            /* List all file encoding formats supported on target and localhost (if OS is Windows)
            ctx.logOutput(" ");
            ctx.logOutput("Listing the file encoding formats supported on " + hostname + "...");
            if(listAllFileEncodingFormats(destination, stdoutHandler, stderrHandler, ctx) != 0) {
                ctx.logError("Failed to execute command. Please check the logs.");
            }
            if (source.getHostOperatingSystem() == WINDOWS && checkPowerShellEnabled(source) == 0) {
                ctx.logOutput(" ");
                ctx.logOutput("Listing the file encoding formats supported on localhost...");
                if (listAllFileEncodingFormats(source, stdoutHandler, stderrHandler, ctx) != 0) {
                    ctx.logError("Failed to execute command. Please check the logs.");
                }
            }*/

            return StepExitCode.SUCCESS;
        } catch (Exception exc) {
            ctx.logError("Cannot execute commands on " + hostname + ". Please check the connection settings.", exc);
            return StepExitCode.FAIL;
        }
    }

    private void checkConnection(ExecutionContext ctx, OverthereConnection connection, OverthereExecutionOutputHandler stdoutHandler, OverthereExecutionOutputHandler stderrHandler) {
        if (echoDefaultEncoding(connection, stdoutHandler, stderrHandler, ctx) != 0 ||
                grepSpecificFileEncodingFormat(connection, stdoutHandler, stderrHandler, ctx) != 0) {
            ctx.logError("Failed to execute command. Please check the logs.");
        }
    }

    private int echoDefaultEncoding(OverthereConnection connection, OverthereExecutionOutputHandler stdoutHandler, OverthereExecutionOutputHandler stderrHandler, ExecutionContext ctx) {
        ctx.logOutput("Default encoding format that is currently used - ");
        CmdLine cmdLine = new CmdLine();
        if (connection.getHostOperatingSystem() == WINDOWS) {
            cmdLine.addArgument("chcp");
        } else {
            cmdLine.addArgument("echo");
            cmdLine.addRaw("$LANG");
        }
        return connection.execute(stdoutHandler, stderrHandler, cmdLine);
    }

    private int grepSpecificFileEncodingFormat(OverthereConnection connection, OverthereExecutionOutputHandler stdoutHandler, OverthereExecutionOutputHandler stderrHandler, ExecutionContext ctx) {
        CmdLine cmdLine;
        if (connection.getHostOperatingSystem() == WINDOWS) {
            ctx.logOutput(" ");
            ctx.logOutput("Checking if UTF-8 and CP1047 are supported...");
            //FIXME with story S-118275
            cmdLine = buildWindowsGrepCommandSimple(connection);
        } else {
            ctx.logOutput(" ");
            ctx.logOutput("Checking if CP1047 is supported on " + hostname + "...");
            cmdLine = new CmdLine().addArgument("iconv").addArgument("-l").addRaw("|").addArgument("grep").addArgument("CP1047");
        }
        return connection.execute(stdoutHandler, stderrHandler, cmdLine);
    }

    //TODO: Add a log before and after method call
    private CmdLine buildWindowsGrepCommandSimple(OverthereConnection connection) {
        return new CmdLine().addArgument("chcp").addArgument("65001").addRaw("&&").addArgument("echo").addArgument("UTF-8").addArgument("is").addArgument("supported").addRaw("||").addArgument("echo").addArgument("UTF-8").addArgument("is").addArgument("not").addArgument("supported").addRaw("&").addArgument("echo").addArgument("CP1047").addArgument("is").addArgument("supported").addRaw("||").addArgument("echo").addArgument("CP1047").addArgument("is").addArgument("not").addArgument("supported");
    }


    /*
       private CmdLine buildWindowsGrepCommand(OverthereConnection connection) {
        CmdLine cmdLine ;
        if (checkPowerShellEnabled(connection) == 0) {
            cmdLine = new CmdLine().addArgument("powershell").addArgument("-Command").addArgument("[System.Text.Encoding]::GetEncodings() | Where-Object { $_.Name -match 'utf-8|1047' }");
        } else {
            cmdLine = new CmdLine().addArgument("chcp").addArgument("65001").addRaw("&&").addArgument("echo").addArgument("UTF-8").addArgument("is").addArgument("supported").addRaw("||").addArgument("echo").addArgument("UTF-8").addArgument("is").addArgument("not").addArgument("supported").addRaw("&").addArgument("echo").addArgument("CP1047").addArgument("is").addArgument("supported").addRaw("||").addArgument("echo").addArgument("CP1047").addArgument("is").addArgument("not").addArgument("supported");
        }
        return cmdLine;
    }

    private int listAllFileEncodingFormats(OverthereConnection connection, OverthereExecutionOutputHandler stdoutHandler, OverthereExecutionOutputHandler stderrHandler, ExecutionContext ctx) {
        CmdLine cmdLine = new CmdLine();
        if (connection.getHostOperatingSystem() == WINDOWS) {
            cmdLine.addArgument("powershell");
            cmdLine.addArgument("-Command");
            cmdLine.addArgument("[System.Text.Encoding]::GetEncodings() | Format-Table CodePage, Name, DisplayName");
        } else {
            cmdLine.addArgument("iconv");
            cmdLine.addArgument("-l");
        }
        return connection.execute(stdoutHandler, stderrHandler, cmdLine);
    }

    private int checkPowerShellEnabled(OverthereConnection connection) {
        CmdLine powershellCmdLine = new CmdLine();
        powershellCmdLine.addArgument("powershell");
        powershellCmdLine.addArgument("-Command");
        powershellCmdLine.addArgument("$PSVersionTable.PSVersion");
        return connection.execute(powershellCmdLine);
    }*/
}