package com.xebialabs.deployit.plugin.overthere;

import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.credentials.HostCredentials;
import com.xebialabs.overthere.cifs.CifsConnectionType;

public final class PasswordValidation {

    private PasswordValidation() {}

    public static class Validator extends BaseValidator {

        protected void validate(Host value, ValidationContext context, String protocol) {
            CifsConnectionType connectionType = value.getProperty("connectionType");
            HostCredentials hostCredentials = value.getProperty("credentials");
            String password = hostCredentials != null ? hostCredentials.getPassword() : value.getProperty("password");
            switch (connectionType) {
                case WINRM_NATIVE:
                    if (password != null && (password.indexOf('\'') != -1 || password.indexOf('\"') != -1)) {
                        context.error("%s/%s host [%s] cannot have a password with a single quote (\') or a double quote (\").", protocol, connectionType, value.getId());
                    }
                    break;
                case TELNET:
                case WINRM_INTERNAL:
                    // no-op
                    break;
            }
        }
    }
}