package com.xebialabs.deployit.plugin.overthere;

import java.util.List;
import java.util.Map;
import com.google.common.collect.Lists;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Delegate;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import com.xebialabs.deployit.plugin.overthere.step.CheckCommandExecutionStep;
import com.xebialabs.deployit.plugin.overthere.step.CheckFileTransferStep;

import static com.xebialabs.deployit.checks.Checks.checkArgument;

public final class CheckConnectionDelegate {

    private CheckConnectionDelegate() {}

    @Delegate(name = "connectionChecker")
    public static List<Step> executedScriptDelegate(ConfigurationItem item, String name, Map<String, String> args, Parameters params) {
        checkArgument(item instanceof Host, "the connectionChecker delegate is for 'overthere.Host' subtypes only");
        return Lists.<Step>newArrayList(
                new CheckFileTransferStep((Host) item),
                new CheckCommandExecutionStep((Host) item));
    }
}
