/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.python;

import com.google.common.base.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.python.PythonManagedContainer;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ControlTaskDelegate {
    private ControlTaskDelegate() {
    }

    public static List<Step> dispatch(String name, Map<String, String> args, ConfigurationItem item, Container container) {
        Object script = args.get("script");
        String lang = args.get("language");
        if (Strings.isNullOrEmpty((String)script)) {
            String scriptPropertyName = name + "PythonScript";
            Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)item.getType());
            PropertyDescriptor propertyDescriptor = descriptor.getPropertyDescriptor(scriptPropertyName);
            Checks.checkArgument((propertyDescriptor != null ? 1 : 0) != 0, (String)"Control task script property %s not defined for CI type %s", (Object[])new Object[]{scriptPropertyName, item.getType()});
            script = (String)propertyDescriptor.get(item);
            script = ((String)script).endsWith(".py") ? script : (String)script + ".py";
            lang = "python";
        }
        Checks.checkArgument((!Strings.isNullOrEmpty((String)script) ? 1 : 0) != 0, (String)"Argument 'script' is required.", (Object[])new Object[0]);
        Checks.checkArgument((!Strings.isNullOrEmpty((String)lang) ? 1 : 0) != 0, (String)"Argument 'language' is required.", (Object[])new Object[0]);
        Checks.checkArgument((lang.equals("python") || lang.equals("os") ? 1 : 0) != 0, (String)"Argument 'language' can only have the values 'os' or 'python' but was %s.", (Object[])new Object[]{lang});
        String itemVarContextName = item instanceof Container ? "container" : "deployed";
        Map<String, ConfigurationItem> thisVarContext = Collections.singletonMap(itemVarContextName, item);
        String desc = "Executing " + name + " on " + String.valueOf(item);
        if (lang.equals("os")) {
            String scriptName = ConfigurationHolder.resolveExpression((String)script, thisVarContext);
            Checks.checkArgument((boolean)(container instanceof HostContainer), (String)"Control task '%s' with shell script '%s' can only be run against a container implementing remote.HostContainer. Container '%s' does not.", (Object[])new Object[]{name, scriptName, container});
            return Collections.singletonList(new ScriptExecutionStep(1, scriptName, (HostContainer)container, thisVarContext, desc));
        }
        String scriptName = ConfigurationHolder.resolveExpression((String)script, thisVarContext);
        PythonManagingContainer pythonManagingContainer = null;
        if (container instanceof PythonManagedContainer) {
            pythonManagingContainer = ((PythonManagedContainer)container).getManagingContainer();
        } else if (container instanceof PythonManagingContainer) {
            pythonManagingContainer = (PythonManagingContainer)container;
        }
        if (pythonManagingContainer == null) {
            throw new IllegalArgumentException(String.format("Control task '%s' with python script '%s' can only be run against a container that is a python.PythonManagingContainer or implements python.PythonManagedContaner. Container '%s' does not.", name, scriptName, container));
        }
        return Collections.singletonList(new PythonDeploymentStep(1, pythonManagingContainer, scriptName, thisVarContext, desc));
    }
}

