package com.xebialabs.deployit.plugin.python;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.remoting.inspection.DeployedInspectionHelper;

import java.util.Map;

@SuppressWarnings("rawtypes")
public class PythonDeployedContainerInspectionHelper<C extends PythonManagedContainer, D extends PythonManagedDeployedContainer>extends DeployedInspectionHelper<C,D> {

    public PythonDeployedContainerInspectionHelper(Class<C> containerSuperClass, Class<D> deployedSuperClass) {
        super(containerSuperClass, deployedSuperClass);
    }

    @Override
    protected Step createInspectionStep(C container, D deployed, String scriptName, Map<String, Object> varsCtx, String description) {
        return new PythonInspectionStep(container, container.getManagingContainer(), scriptName, varsCtx, description);
    }
}
