package com.xebialabs.deployit.plugin.python;

import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereFile;

/**
 * Interface implemented by containers that manage other containers through Python.
 */
public interface PythonManagingContainer extends Container {

    /**
     * Name of the Python function to implement in the container specific runtime that connects to the managing server, when running from a stand alone script.
     */
    String CONNECT_FROM_STAND_ALONE_SCRIPT = "connectFromStandAloneScript";

    /**
     * Name of the Python function to implement in the container specific runtime that disconnects from the managing server, when running from a stand alone
     * script.
     */
    String DISCONNECT_FROM_STAND_ALONE_SCRIPT = "disconnectFromStandAloneScript";

    /**
     * Name of the Python function to implement in the container specific runtime that connects to the managing server, when running from the daemon.
     */
    String CONNECT_FROM_DAEMON = "connectFromDaemon";

    /**
     * Name of the Python function to implement in the container specific runtime that runs a script from the daemon.
     */
    String RUN_SCRIPT_FROM_DAEMON = "runScriptFromDaemon";

    /**
     * Name of the Python function to implement in the container specific runtime that disconnects from the managing server, when running from the daemon.
     */
    String DISCONNECT_FROM_DAEMON = "disconnectFromDaemon";

    /**
     * Returns the host on which this container runs.
     */
    Host getHost();

    /**
     * Returns the name of the directory on the classpath that contains the PowerShell scripts that define the runtime for this container. Should implement
     * {@link #CONNECT_FROM_STAND_ALONE_SCRIPT}, {@link #DISCONNECT_FROM_STAND_ALONE_SCRIPT}, {@link #CONNECT_FROM_DAEMON}, {@link #RUN_SCRIPT_FROM_DAEMON},
     * {@link #DISCONNECT_FROM_DAEMON}.
     */
    String getRuntimePath();

    /**
     * <code>true</code> if the python daemon should be started to manage this container.
     */
    boolean runWithDaemon();

    /**
     * Generates the command line that should be used to run a script.
     * 
     * @param script
     *            the script to run
     * @return the command line to use to run the script.
     */
    CmdLine getScriptCommandLine(OverthereFile script);

}
