package com.xebialabs.deployit.plugin.powershell;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.overthere.HostContainer;

import static com.xebialabs.deployit.checks.Checks.checkArgument;
import static com.google.common.base.Strings.isNullOrEmpty;

public final class ControlTaskDelegate {

    private ControlTaskDelegate() {}

    public static List<Step> dispatch(String name, Map<String, String> args, ConfigurationItem item, HostContainer container) {
        String script = args.get("script");
        checkArgument(!isNullOrEmpty(script), "Argument 'script' is required.");

        String itemVarContextName = (item instanceof Container) ? "container" : "deployed";
        Map<String, Object> thisVarContext = Collections.singletonMap(itemVarContextName, (Object) item);

        String desc = "Executing " + name + " on " + item;
        PowerShellDeploymentStep step = new PowerShellDeploymentStep(1, container, null, script, thisVarContext, desc);
        return Collections.<Step>singletonList(step);
    }

}
