/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.powershell;

import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.planning.Noop;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.validation.Regex;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.powershell.BasePowerShellDeployedArtifact;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(virtual=true)
public class BaseExtensiblePowerShellDeployedArtifact<D extends DeployableArtifact>
extends BasePowerShellDeployedArtifact<D, HostContainer> {
    @Property(hidden=true, defaultValue="60", description="Order at which the create step will be executed.")
    int createOrder;
    @Property(hidden=true, required=false, description="PowerShell script invoked to create a resource (or deploy an artifact) on Windows.")
    String createScript;
    @Property(hidden=true, defaultValue="Create", description="Verb that is used to prefix the description for the create step.")
    String createVerb;
    @Property(hidden=true, defaultValue="uploadArtifactData,uploadClasspathResources", description="Options for the create step (1 or more of: none,uploadArtifactData,uploadClasspathResources,exposeDeployedApplication,exposePreviousDeployed).")
    @Regex(pattern="(none|uploadArtifactData|uploadClasspathResources|exposeDeployedApplication|exposePreviousDeployed)")
    Set<String> createOptions;
    @Property(hidden=true, defaultValue="60", description="Order at which the modify step will be executed.")
    int modifyOrder;
    @Property(hidden=true, required=false, description="PowerShell script invoked to modify a resource (or an artifact) on Windows.")
    String modifyScript;
    @Property(hidden=true, defaultValue="Modify", description="Verb that is used to prefix the description for the modify step.")
    String modifyVerb;
    @Property(hidden=true, defaultValue="uploadArtifactData,uploadClasspathResources", description="Options for the modify step (1 or more of: none,uploadArtifactData,uploadClasspathResources,exposeDeployedApplication,exposePreviousDeployed).")
    @Regex(pattern="(none|uploadArtifactData|uploadClasspathResources|exposeDeployedApplication|exposePreviousDeployed)")
    Set<String> modifyOptions;
    @Property(hidden=true, defaultValue="40", description="Order at which the destroy step will be executed.")
    int destroyOrder;
    @Property(hidden=true, required=false, description="PowerShell script invoked to destroy a resource (or undeploy an artifact) on Windows.")
    String destroyScript;
    @Property(hidden=true, defaultValue="Destroy", description="Verb that is used to prefix the description for the destroy step.")
    String destroyVerb;
    @Property(hidden=true, defaultValue="uploadClasspathResources", description="Options for the destroy step (1 or more of: none,uploadArtifactData,uploadClasspathResources,exposeDeployedApplication,exposePreviousDeployed).")
    @Regex(pattern="(none|uploadArtifactData|uploadClasspathResources|exposeDeployedApplication|exposePreviousDeployed)")
    Set<String> destroyOptions;
    @Property(hidden=true, defaultValue="50", description="Order at which the noop step will be executed.")
    int noopOrder;
    @Property(hidden=true, required=false, description="PowerShell script invoked to noop a resource or an artifact on Windows.")
    String noopScript;
    @Property(hidden=true, defaultValue="Noop", description="Verb that is used to prefix the description for the noop step.")
    String noopVerb;
    @Property(hidden=true, defaultValue="uploadClasspathResources", description="Options for the noop step (1 or more of: none,uploadArtifactData,uploadClasspathResources,exposeDeployedApplication,exposePreviousDeployed).")
    @Regex(pattern="(none|uploadArtifactData|uploadClasspathResources|exposeDeployedApplication|exposePreviousDeployed)")
    Set<String> noopOptions;
    @Property(hidden=true, defaultValue="90", description="Order at which the start step will be executed.")
    int startOrder;
    @Property(hidden=true, required=false, description="PowerShell script invoked to start a resource of an artifact on Windows.")
    String startScript;
    @Property(hidden=true, defaultValue="Start", description="Verb that is used to prefix the description for the start step.")
    String startVerb;
    @Property(hidden=true, defaultValue="uploadClasspathResources", description="Options for the start step (1 or more of: none,uploadArtifactData,uploadClasspathResources,exposeDeployedApplication,exposePreviousDeployed).")
    @Regex(pattern="(none|uploadArtifactData|uploadClasspathResources|exposeDeployedApplication|exposePreviousDeployed)")
    Set<String> startOptions;
    @Property(hidden=true, defaultValue="10", description="Order at which the stop script will be executed.")
    int stopOrder;
    @Property(hidden=true, required=false, description="PowerShell script invoked to stop a resource or an artifact on Windows.")
    String stopScript;
    @Property(hidden=true, defaultValue="Stop", description="Verb that is used to prefix the description for the stop step.")
    String stopVerb;
    @Property(hidden=true, defaultValue="uploadClasspathResources", description="Options for the stop step (1 or more of: none,uploadArtifactData,uploadClasspathResources,exposeDeployedApplication,exposePreviousDeployed).")
    @Regex(pattern="(none|uploadArtifactData|uploadClasspathResources|exposeDeployedApplication|exposePreviousDeployed)")
    Set<String> stopOptions;
    @Property(required=false, defaultValue="true", category="Deployment", label="Start when created", description="If set to true, the start script will be executed if this deployed is being created.")
    boolean startOnCreate;
    @Property(required=false, defaultValue="true", category="Deployment", label="Stop when destroyed", description="If set to true, the stop script will be executed if this deployed is being destroyed.")
    boolean stopOnDestroy;
    @Property(required=false, defaultValue="true", category="Deployment", label="Stop and start when modified", description="If set to true, the stop and start scripts will be executed if this deployed is being modified.")
    boolean stopStartOnModify;
    @Property(required=false, defaultValue="true", category="Deployment", label="Stop and start when not modified", description="If set to true, the stop and start scripts will be executed if this deployable is not being modified.")
    boolean stopStartOnNoop;
    @Property(hidden=true, required=false, defaultValue="false", category="Deployment", label="Batch steps", description="If set to true, multiple steps at the same order will be batched together in one batch to improve performance over high-latency WinRM connections")
    boolean batchSteps;
    @Property(hidden=true, required=true, defaultValue="100", category="Deployment", label="Maximum batch size", description="Maximum number of steps in a batch.")
    int maxBatchSize;
    private static Logger logger = LoggerFactory.getLogger(BaseExtensiblePowerShellDeployedArtifact.class);

    boolean shouldBatch() {
        if (!this.batchSteps) {
            logger.debug("Should NOT batch [{}] because batchSteps=false", (Object)this.getId());
            return false;
        }
        if (this.getClasspathResources() != null && !this.getClasspathResources().isEmpty()) {
            logger.debug("Should NOT batch [{}] because it has classpath resources", (Object)this.getId());
            return false;
        }
        logger.debug("Should batch [{}]", (Object)this.getId());
        return true;
    }

    @Create
    public void create(DeploymentPlanningContext ctx, Delta delta) {
        if (this.shouldBatch()) {
            return;
        }
        this.addStepWithCheckpoint(ctx, delta, Operation.CREATE, this.createOrder, this.createScript, this.createVerb, this.createOptions);
        if (delta.getOperation() == Operation.CREATE && this.startOnCreate || delta.getOperation() == Operation.MODIFY && this.stopStartOnModify) {
            this.start(ctx, delta);
        }
    }

    @Modify
    public void modify(DeploymentPlanningContext ctx, Delta delta) {
        if (this.shouldBatch()) {
            return;
        }
        if (this.addStepWithCheckpoint(ctx, delta, Operation.MODIFY, this.modifyOrder, this.modifyScript, this.modifyVerb, this.modifyOptions)) {
            if (this.stopStartOnModify) {
                this.start(ctx, delta);
                this.stop(ctx, delta);
            }
        } else {
            BaseExtensiblePowerShellDeployedArtifact previous = (BaseExtensiblePowerShellDeployedArtifact)delta.getPrevious();
            previous.destroy(ctx, delta);
            BaseExtensiblePowerShellDeployedArtifact current = (BaseExtensiblePowerShellDeployedArtifact)delta.getDeployed();
            current.create(ctx, delta);
        }
    }

    @Destroy
    public void destroy(DeploymentPlanningContext ctx, Delta delta) {
        if (this.shouldBatch()) {
            return;
        }
        this.addStepWithCheckpoint(ctx, delta, Operation.DESTROY, this.destroyOrder, this.destroyScript, this.destroyVerb, this.destroyOptions);
        if (delta.getOperation() == Operation.DESTROY && this.stopOnDestroy || delta.getOperation() == Operation.MODIFY && this.stopStartOnModify) {
            this.stop(ctx, delta);
        }
    }

    @Noop
    public void noop(DeploymentPlanningContext ctx, Delta delta) {
        if (this.shouldBatch()) {
            return;
        }
        this.addStepWithCheckpoint(ctx, delta, Operation.NOOP, this.noopOrder, this.noopScript, this.noopVerb, this.noopOptions);
        if (this.stopStartOnNoop) {
            this.stop(ctx, delta);
            this.start(ctx, delta);
        }
    }

    private void start(DeploymentPlanningContext ctx, Delta delta) {
        this.addStep(ctx, delta, this.startOrder, this.startScript, this.startVerb, this.startOptions);
    }

    private void stop(DeploymentPlanningContext ctx, Delta delta) {
        this.addStep(ctx, delta, this.stopOrder, this.stopScript, this.stopVerb, this.stopOptions);
    }
}

