package com.xebialabs.deployit.plugin.powershell;

import com.google.common.base.Joiner;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.remoting.vars.VarsConverter;
import com.xebialabs.overthere.OverthereConnection;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import static com.google.common.collect.Lists.newArrayList;

public abstract class BasePowershellVarsConverter extends VarsConverter {

    public BasePowershellVarsConverter(OverthereConnection connection, Map<String, Object> pythonVars, boolean maskPasswords, boolean exposePasswordPropertiesOnHosts) {
        super(connection, pythonVars, maskPasswords, exposePasswordPropertiesOnHosts);
    }

    @Override
    protected void endCreateObject(String variableName) {
        // no-op
    }

    protected void setNoteProperty(String objectName, String propertyName, String literalPropertyValue) {
        add("$" + objectName + " | Add-Member NoteProperty " + toPowerShellString(propertyName) + " " + literalPropertyValue);
    }

    @Override
    protected void setNullProperty(String objectName, String propertyName) {
        setNoteProperty(objectName, propertyName, "$null");
    }

    @Override
    protected void setEmptyCollectionProperty(String objectName, String propertyName) {
        setNoteProperty(objectName, propertyName, "@()");
    }

    @Override
    protected void setEmptyMapProperty(String objectName, String propertyName) {
        setNoteProperty(objectName, propertyName, "@{}");
    }

    @Override
    protected void setCiReferenceProperty(String objectName, String propertyName, ConfigurationItem propertyValue) {
        setNoteProperty(objectName, propertyName, "$" + getConfigurationItemVariableName(propertyValue));
    }

    @Override
    protected void setCollectionOfCiReferencesProperty(String objectName, String propertyName, Collection<ConfigurationItem> propertyValue) {
        List<String> varRefs = newArrayList();
        for (ConfigurationItem setItem : propertyValue) {
            varRefs.add("$" + getConfigurationItemVariableName(setItem));
        }
        setNoteProperty(objectName, propertyName, "@(" + Joiner.on(", ").join(varRefs) + ")");
    }

    @Override
    protected void createObjectAndSetObjectProperty(String objectName, String propertyName) {
        String embeddedObjectVariableName = generateUniqueVariableName();
        startCreateObject(embeddedObjectVariableName);
        endCreateObject(embeddedObjectVariableName);
        setNoteProperty(objectName, propertyName, "$" + embeddedObjectVariableName);
    }

    public static String toPowerShellString(String str) {
        StringBuilder converted = new StringBuilder();
        converted.append("\'");
        for (int i = 0; i < str.length(); i++) {
            char c = str.charAt(i);
            if (c == '\'') {
                converted.append("\'\'");
            } else {
                converted.append(c);
            }
        }
        converted.append("\'");
        return converted.toString();
    }


}
