package com.xebialabs.deployit.plugin.policy;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.security.permission.PermissionHelper;
import com.xebialabs.xlplatform.scheduler.ci.StepJob;

@Retention(RetentionPolicy.RUNTIME)
@Rule(clazz = PermissionValidator.Validator.class, type = "permission")
@Target(ElementType.TYPE)
public @interface PermissionValidator {
    class Validator implements com.xebialabs.deployit.plugin.api.validation.Validator<StepJob> {

        @Override
        public void validate(StepJob job, ValidationContext context) {
            if (!PermissionHelper.isCurrentUserAdmin()) {
                context.error("The operation is only allowed to admin users.");
            }
        }
    }
}
