#
class PolicyRegistry():
    _policy_classes = {}

    def __init__(self):
        pass

    @staticmethod
    def register_policy(alias, cls):
        PolicyRegistry._policy_classes[alias] = cls

    @staticmethod
    def new_policy(alias, context):
        if alias not in PolicyRegistry._policy_classes:
            raise Exception("Policy alias [%s] not registered" % alias)
        return PolicyRegistry._policy_classes[alias](context)