package com.xebialabs.deployit.plugin.policy

import com.xebialabs.deployit.deployment.rules._
import com.xebialabs.deployit.plugin.api.flow.Step
import com.xebialabs.deployit.plugin.api.rules.{Scope, StepPostConstructContext}
import nl.javadude.scannit.Scannit

object StepFactoryHelper {
  private val stepRegistry = new SimpleStepRegistry()
  StepClassScanner.fill(stepRegistry, Scannit.getInstance())

  private val stepFactory = new StepFactory(StepFactoryHelper.stepRegistry, new StepPostConstructContext(Scope.PLAN, null, null, null), new XmlParameterResolver(StepFactoryHelper.stepRegistry))

  def newStep(stepName: String, stepParameters: Map[String, Any] = Map.empty): Step = {
    StepFactoryHelper.stepFactory.step(new StepData(stepName, stepParameters))
  }
}
