/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.notification.mail;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.TypeIcon;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.util.List;
import java.util.Map;
import java.util.Properties;

@Metadata(root=Metadata.ConfigurationItemRoot.CONFIGURATION, description="PAT SMTP Mail Server Configuration")
@TypeIcon(value="icons/types/mail.SmtpServer.svg")
public class PatSmtpServer
extends BaseConfigurationItem {
    public static final String DEFAULT_SMTP_SERVER_NAME = "defaultSmtpServer";
    @Property(description="SMTP host")
    private String host;
    @Property(description="SMTP port", defaultValue="25")
    private int port;
    @Property(required=false, description="Username to authenticate with host")
    private String username;
    @Property(required=false, password=true, description="Password to authenticate with host")
    private String password;
    @Property(description="Default from address to use for messages sent with this server.")
    private String fromAddress;
    @Property(required=false, description="The address to which a test mail is sent when using the 'Send Test Mail' control task.")
    private String testAddress;
    @Property(required=false, description="Refer to https://javaee.github.io/javamail/docs/api/com/sun/mail/smtp/package-summary.html for all properties that can be used.")
    private Map<String, String> smtpProperties = Maps.newHashMap();
    private transient Session session;

    private MimeMessage createMimeMessage(List<String> toAddresses, String fromAddress, String subject) throws MessagingException {
        this.session = this.getSession();
        MimeMessage message = new MimeMessage(this.session);
        String addresses = Joiner.on((char)',').join(toAddresses);
        InternetAddress[] internetAddresses = InternetAddress.parse((String)addresses);
        message.setRecipients(Message.RecipientType.TO, (Address[])internetAddresses);
        message.setSubject(subject);
        if (!Strings.isNullOrEmpty((String)fromAddress)) {
            message.setFrom((Address)InternetAddress.parse((String)fromAddress)[0]);
        }
        return message;
    }

    public void sendMessage(String subject, String msg, List<String> toAddresses, String fromAddress) throws MessagingException {
        this.sendMessage(subject, msg, toAddresses, fromAddress, false);
    }

    public void sendMessage(String subject, String msg, List<String> toAddresses, String fromAddress, boolean isHtmlMsg) throws MessagingException {
        MimeMessage message = this.createMimeMessage(toAddresses, fromAddress, subject);
        if (isHtmlMsg) {
            message.setText(msg, null, "html");
        } else {
            message.setText(msg);
        }
        Transport.send((Message)message);
    }

    public void sendMultipartMessage(String subject, MimeMultipart multipart, List<String> toAddresses, String fromAddress) throws MessagingException {
        MimeMessage message = this.createMimeMessage(toAddresses, fromAddress, subject);
        message.setContent((Multipart)multipart);
        Transport.send((Message)message);
    }

    @ControlTask
    public List<Step> sendTestMail() {
        Checks.checkArgument((!Strings.isNullOrEmpty((String)this.testAddress) ? 1 : 0) != 0, (String)"Please fill in the testAddress property before trying to send a test mail.", (Object[])new Object[0]);
        Step step = new Step(){

            public int getOrder() {
                return 1;
            }

            public String getDescription() {
                return "Sending test mail to " + PatSmtpServer.this.testAddress;
            }

            public StepExitCode execute(ExecutionContext ctx) throws Exception {
                ctx.logOutput("Sending test mail...");
                PatSmtpServer.this.sendMessage("Test Mail", "Test message from XL Deploy.", Lists.newArrayList((Object[])new String[]{PatSmtpServer.this.testAddress}), null);
                ctx.logOutput("Sent successfully.");
                return StepExitCode.SUCCESS;
            }
        };
        return Lists.newArrayList((Object[])new Step[]{step});
    }

    private Session getSession() {
        if (this.session == null) {
            this.session = Session.getInstance((Properties)this.getSessionProperties(), (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(Strings.nullToEmpty((String)PatSmtpServer.this.username), Strings.nullToEmpty((String)PatSmtpServer.this.password));
                }
            });
        }
        return this.session;
    }

    private Properties getSessionProperties() {
        Properties props = new Properties();
        String authEnabled = "true";
        if (Strings.isNullOrEmpty((String)this.username) || Strings.isNullOrEmpty((String)this.password)) {
            authEnabled = "false";
        }
        props.put("mail.smtp.auth", authEnabled);
        props.put("mail.smtp.host", this.host);
        props.put("mail.smtp.port", (Object)this.port);
        props.put("mail.smtp.from", this.fromAddress);
        props.putAll(this.smtpProperties);
        return props;
    }

    public static PatSmtpServer getMailServer(DeploymentPlanningContext ctx) {
        DeployedApplication application = ctx.getDeployedApplication() == null ? ctx.getPreviousDeployedApplication() : ctx.getDeployedApplication();
        return PatSmtpServer.getMailServer(application.getEnvironment(), ctx.getRepository());
    }

    public static PatSmtpServer getMailServer(Environment environment, Repository repo) {
        PatSmtpServer smtpServer = (PatSmtpServer)((Object)environment.getProperty("smtpServer"));
        if (smtpServer == null) {
            smtpServer = PatSmtpServer.findDefaultSmtpServer(repo);
        }
        if (smtpServer == null) {
            throw new IllegalArgumentException(String.format("No default SmtpServer [%s] found under Configuration root, and Environment [%s] does not have an SmtpServer configured.", DEFAULT_SMTP_SERVER_NAME, environment.getId()));
        }
        return smtpServer;
    }

    private static PatSmtpServer findDefaultSmtpServer(Repository repo) {
        List search = repo.search(Type.valueOf(PatSmtpServer.class));
        Optional configurationItemOptional = Iterables.tryFind((Iterable)search, (Predicate)new Predicate<PatSmtpServer>(){

            public boolean apply(PatSmtpServer input) {
                return input.getName().equals(PatSmtpServer.DEFAULT_SMTP_SERVER_NAME);
            }
        });
        return (PatSmtpServer)((Object)configurationItemOptional.orNull());
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public Map<String, String> getSmtpProperties() {
        return this.smtpProperties;
    }

    public void setSmtpProperties(Map<String, String> smtpProperties) {
        this.smtpProperties = smtpProperties;
    }
}

