package ai.digital.deploy.notification.freemarker;

import freemarker.template.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.concurrent.atomic.AtomicReference;


public class FreeMarkerConfigurationHolder {

    private static final AtomicReference<Configuration> holder = new AtomicReference<>();

    private FreeMarkerConfigurationHolder() {}
    public static Configuration getConfiguration() {
        Configuration conf = holder.get();
        if (conf == null) {
            conf = init();
            if (!holder.compareAndSet(null, conf)) {
                // another thread has initialized the reference
                conf = holder.get();
            }
        }
        return conf;
    }
    private static Configuration init() {
        Configuration conf = new Configuration();
        conf.setNumberFormat("computer");
        conf.setTemplateLoader(new ClasspathTemplateLoader());
        return conf;
    }

    private static final Logger logger = LoggerFactory.getLogger(FreeMarkerConfigurationHolder.class);
}
