package com.xebialabs.deployit.plugins.lock;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Tasks are capable to execute steps concurrently.
 *
 * This class provides a way to make sure the locks persisted in DB
 * are visible to the steps during the task execution
 *
 */
public class TaskLockManager {

    private static Map<String, ReentrantLock> taskLocks = new ConcurrentHashMap<>();

    public static ReentrantLock getLock(String taskId) {
        return taskLocks.computeIfAbsent(taskId, s -> new ReentrantLock());
    }

    public static void clearLock(String taskId) {
        taskLocks.remove(taskId);
    }
}
