package com.xebialabs.deployit.plugins.lock;

import com.xebialabs.deployit.local.message.DeployMessageHolder;
import com.xebialabs.deployit.local.message.ProductName;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.repository.sql.lock.CiLockRepositoryHolder;

import java.util.Collections;
import java.util.List;

import static scala.jdk.javaapi.CollectionConverters.asJava;
import static scala.jdk.javaapi.CollectionConverters.asScala;

@Metadata(root = Metadata.ConfigurationItemRoot.INFRASTRUCTURE, description = "Manager for container locks")
public class Manager extends BaseContainer {

    private String getMessage(String msgKey) {
        return DeployMessageHolder.getMessage(msgKey, asScala(List.of()).toSeq());
    }

    @ControlTask(description = "Clears all locks")
    public List<Step> clearLocks() {
        Step clearLocksStep = new Step() {

            @Override
            public String getDescription() {
                return getMessage("clear.all.locks");
            }

            @Override
            public StepExitCode execute(ExecutionContext ec) {
                CiLockRepositoryHolder.getCiLockRepository().clearAllLocks();
                return StepExitCode.SUCCESS;
            }

            @Override
            public int getOrder() {
                return 0;
            }
        };

        return Collections.singletonList(clearLocksStep);
    }

    @ControlTask(description = "Lists all locks")
    public List<Step> listLocks() {
        Step listLocksStep = new Step() {

            @Override
            public String getDescription() {
                return getMessage("list.all.locks");
            }

            @Override
            public StepExitCode execute(ExecutionContext ctx) {
                ctx.logMsgOutput(ProductName.DEPLOY, "currently.locked.ci");

                List<String> locksListing = asJava(CiLockRepositoryHolder.getCiLockRepository().listAllLocks());
                if (locksListing.isEmpty()) {
                    ctx.logOutput("<none>");
                } else {
                    locksListing.forEach(ci -> ctx.logOutput("- " + ci));
                }

                return StepExitCode.SUCCESS;
            }

            @Override
            public int getOrder() {
                return 0;
            }
        };

        return Collections.singletonList(listLocksStep);
    }
}
